unit Display;
// Display.pas version 1.0.2 31/1/2
// Copyright (C) 2002 Clment Gatin - UB42

interface


uses
Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Dialogs,
     DirectDraw,
     DDUtil,
     GestionDX;

type
  //Type TNepSurface. Le nom vient de NepioPhobia, le nom de notre jeu.
  //C'est une classe (sert  crer des objets). Cela n'a pas d'importance pour l'utilisateur
  //du module puisque la cration ou le dchargement est gr par le module.
  TNepSurface = class
    DDSurface:IDirectDrawSurface7; //Surface DirectDraw lie  l'objet.
    BMPFileName:PChar; //Nom du fichier BMP. Utilis en interne par le moteur pour recharger les surfaces aprs un Alt+Tab.
    Index:Integer; //Numro de l'objet dans le tableau contenant toutes les surfaces.
    procedure LoadFromBMPFile(FileName:PChar); //Procdure de chargement  partir d'un fichier BMP
    procedure BlitXY(X,Y,srcX,srcY,Width,Height:integer;Transparent:Boolean); //Procdure de Blit. Saviez-vous que BLIT signifiait BLock Image Transfer ?
    procedure SetTransparentColor(Color:cardinal); //Procdure de dsignation de la couleur de transparence
    procedure SetTransColorXY(X,Y:integer); //Idem prcdent, mais en prcisant les coordonnes XY. Plus lent, utilise momentanment plus de mmoire aussi.
    procedure FreeSurface; //Dchargement de la surface.
  end;

var
  FDDSPrimary    : IDirectDrawSurface7;  //Objet Surface Primaire
  FDDSBack       : IDirectDrawSurface7;  //Objet Surface BackBuffer
  Surfaces       : Array of TNepSurface; //Tableau contenant toutes les surfaces.

  function GetNewSurface():TNepSurface; //Procdure permettant de crer une nouvelle surface (cr l'objet, le place dans le tableau)
  procedure InitDirectDraw(Handle:HWND;ScreenWidth,ScreenHeight,ScreenBitDepth:Cardinal); //Initialisation de DirectDraw
  procedure Flip(); //Echange des surfaces BackBuffer et Primary
  function RestoreAll: HRESULT; //fonction grant la restauration des surfaces aprs un Alt+Tab
  procedure FreeSurfaces; //Procdure de laibration de toutes les surfaces (sauf Primary eyt Backbuffer)
  procedure ExitDirectDraw; //Procdure d'arrt de DirectDraw. Appelle automatiquement la procdure prcdente.


implementation

procedure InitDirectDraw(Handle:HWND;ScreenWidth,ScreenHeight,ScreenBitDepth:Cardinal);
var
  ddsd    : TDDSurfaceDesc2;
  ddscaps : TDDSCaps2;
  hRet    : HRESULT;
begin
   // Cr l'objet DirectDraw
  hRet := DirectDrawCreateEx(nil, FDD, IDirectDraw7, nil);
  if hRet <> DD_OK then
    begin
      ErrorOut(hRet, 'DirectDrawCreateEx');
      Exit;
    end;

  // Dfinit le Cooperative Level (mode de fonctionnement de DirectX : on veut bosser en plein cran, avoir l'exclusivit, et autoriser le reboot (et aussi le Alt+Tab je crois)
  hRet := FDD.SetCooperativeLevel(Handle, DDSCL_FULLSCREEN or DDSCL_EXCLUSIVE or DDSCL_ALLOWREBOOT);
  if hRet <> DD_OK then
    begin
      ErrorOut(hRet, 'SetCooperativeLevel');
      Exit;
    end;

  // Dfinit le mode d'affichage
  hRet := FDD.SetDisplayMode(ScreenWidth, ScreenHeight, ScreenBitDepth, 0, 0);
  if hRet <> DD_OK then
    begin
      ErrorOut(hRet, 'SetDisplayMode');
      Exit;
    end;

  // Cr la surface primaire
  FillChar(ddsd, SizeOf(ddsd), 0);
  ddsd.dwSize := SizeOf(ddsd);
  ddsd.dwFlags := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
  ddsd.ddsCaps.dwCaps := DDSCAPS_PRIMARYSURFACE or DDSCAPS_FLIP or DDSCAPS_COMPLEX;
  ddsd.dwBackBufferCount := 1;
  hRet := FDD.CreateSurface(ddsd, FDDSPrimary, nil);
  if hRet <> DD_OK then
    begin
      ErrorOut(hRet, 'CreateSurface');
      Exit;
    end;

  // Cr le backbuffer
  FillChar(ddscaps, SizeOf(ddscaps), 0);
  ddscaps.dwCaps := DDSCAPS_BACKBUFFER;
  hRet := FDDSPrimary.GetAttachedSurface(ddscaps, FDDSBack);
  if hRet <> DD_OK then
    begin
      ErrorOut(hRet, 'GetAttachedSurface');
      Exit;
    end;

end;

procedure TNepSurface.LoadFromBMPFile(FileName:PChar);
var
  hRet : HRESULT;
begin
  //Charge le fichier ) partr de son nom.
  DDSurface := DDLoadBitmap(FDD, FileName,  0, 0);
  //Enregsitre le nom du fichier pour le restore
  BMPFileName := FileName;
  hRet := 0;
  if DDSurface = nil then
    begin
      ErrorOut(hRet, 'DDLoadBitmap');
      Exit;
    end;
end;

procedure TNepSurface.SetTransparentColor(Color:cardinal);
begin
  //Dfinit la couleur de transparence.
  DDSetColorKey(DDSurface, Color);
end;

procedure TNepSurface.BlitXY(X,Y,srcX,srcY,Width,Height:integer;Transparent:Boolean);
var
  rcRect : TRect;
  hRet : HRESULT;
  tmpFlag:Cardinal;
begin
  //Dfinit le rectangle  partir duquel on extrait l'image (rcRect est juste un record avec 4 variables Top, Left, Right, Bottom, rien de bien mchant)
  SetRect(rcRect, srcX, srcY, Width + srcX, Height + srcY);

  while True do // Boucle 'infinie' : on boucle jusqu'  avoir russi ce que l'on voulait.
    begin
      //Dfinit la transparence
      if Transparent then tmpFlag := DDBLTFAST_SRCCOLORKEY else tmpFlag := DDBLTFAST_NOCOLORKEY;
      //Appelle le Blit
      hRet := FDDSBack.BltFast(X, Y, DDSurface, @rcRect, tmpFlag);
      //Vrification de l'tat en cours
      if hRet = DD_OK then //Si OK, on quitte la boucle
        begin
          Break;
        end;
      if hRet = DDERR_SURFACELOST then //Si erreur de surface perdue, on restore les surfaces
        begin
          hRet := RestoreAll;
          if hRet <> DD_OK then
            begin
              Exit;
            end;
        end;
      if hRet <> DDERR_WASSTILLDRAWING then //Si autre erreur que 'en train de dessiner', on quitte.
        begin
          Exit;
        end;
    end;
end;

procedure Flip();
var
  hRet : HRESULT;
begin
  // Essaie de flipper les surfaces
  while True do
    begin
      // Flip les surfaces
      hRet := FDDSPrimary.Flip(nil, 0);
      if hRet = DD_OK then
        begin
          Break;
        end
      // Restore surface si elles sont perdues
      else if hRet = DDERR_SURFACELOST then
        begin
          hRet := RestoreAll;
          if hRet <> DD_OK then
            begin
              Exit;
            end;
        end
      // Erreur inattendue
      else if hRet <> DDERR_WASSTILLDRAWING then
        begin
          Exit;
        end;
    end;
end;

function GetNewSurface():TNepSurface;
begin
  //Cration d'une nouvelle surface :
  //On ajoute une place au tableau
  SetLength(Surfaces,Length(Surfaces)+1);
  //On cr une surface dans cette place
  Surfaces[length(surfaces)-1]:=TNepSurface.Create;
  //On fixe l'index de la surface
  Surfaces[length(surfaces)-1].Index := Length(surfaces)-1;
  //On renvoie la surface
  Result:=Surfaces[length(surfaces)-1];

end;

procedure TNepSurface.SetTransColorXY(X,Y:integer);
var
Bmp:TBitmap;
Color:Cardinal;
begin
  //On cr un objet bitmap pour charger l'image
  Bmp := TBitmap.Create();
  //On charge l'image
  Bmp.LoadFromFile(BmpFileName);
  //On rcupre la couleur
  Color := Bmp.Canvas.Pixels[X,Y];
  //On appelle la fonction de spcification de la couleur
  SetTransparentColor(Color);
  //On dcharge le bitmap
  Bmp.Free;



end;

function RestoreAll: HRESULT;
var
  hRet : HRESULT;
  n:integer;
begin
  //recharge la surface primaire
  hRet := FDDSPrimary._Restore;
  if hRet = DD_OK then
    begin
      for n := 0 to Length(Surfaces)-1 do begin //Pour chaque surface, recharge la surface et son bitmap.
        hRet := Surfaces[n].DDSurface._Restore;
        if hRet = DD_OK then
          hRet := DDReLoadBitmap(Surfaces[n].DDSurface, Surfaces[n].BMPFileName);
      end;
    end;
  Result := hRet;
end;

procedure ExitDirectDraw;
begin
  // Je regarde si les surfaces ont t cres et je les libre.
  if Assigned(FDD) then
    begin
      if Assigned(FDDSBack) then
        begin
          FDDSBack := nil;
        end;
      if Assigned(FDDSPrimary) then
        begin
          FDDSPrimary := nil;
        end;
      //Libre les surfaces du tableau
      FreeSurfaces;
    end;
end;

procedure FreeSurfaces;
var
n:integer;
begin
  //Pour chaque surface
  for n := 0 to Length(Surfaces)-1 do
    begin
      If Assigned(Surfaces[n].DDSurface) then
      begin
        //Si elle est bien assigne, je dtruits sa surface DirectDraw
        Surfaces[n].DDSurface := nil;
        //Avant de librer l'objet associ
        Surfaces[n].Free;
      end;
    end;
  //Vide le tableau
  SetLength(Surfaces,0);
end;

procedure TNepSurface.FreeSurface;
var
n:integer;
begin
  If Assigned(DDsurface) then
  begin
    DDSurface := nil;
  end;
  Free;
  //supprimme la surface du tableau.
  for n := Index to Length(Surfaces) - 2 do begin
    Surfaces[n] := Surfaces[n+1];
    Surfaces[n].Index := n;

  end;
  //Vide la case non ncessaire.
  SetLength(Surfaces, Length(Surfaces)-1);

  Free;
end;

end.
